// Pulse Position Modulation
// (c) 2007, Idle Loop Software Design, LLC
//
// contact: robotics@idleloop.com
//
// This code is supplied as sample code and may be freely used,
// without any sort of warrantee whatsoever. You've been warned.
//
// The following is intended to decode the signal coming out of a
// Vex R/C receiver, but should work for any PPM signal.
//
// This is written for an Atmel ATmega processor.
//
// You'll need to supply a couple of timer functions. See comments
// in the accompanying C++ file.


// some basic stuff
typedef unsigned char uchar;
typedef unsigned int uint;
typedef unsigned long ulong;

#define DIM(a) (sizeof(a)/sizeof((a)[0]))

enum { fFalse = 0, fTrue = 1 };

// the PPM stuff...

typedef enum
{
	channel1 = 0,
	channel2,
	channel3,
	channel4,
	channel5,
	channel6,
	cchannel
} CHAN;

void StartPPMDecoder();
uchar PwmGetChannel(CHAN channel);
int FChannelUpdate(CHAN channel);
